#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "simgrid/actor.h"
#include "simgrid/engine.h"
#include "simgrid/host.h"
#include "simgrid/mailbox.h"
#include "simgrid/mutex.h"
#include "simgrid/cond.h"


int client(int argc, char *argv[]);
int server(int argc, char *argv[]);


#define FINALIZE ((void*)221297)        /* a magic number to tell people to stop working */

#define N_TASKS  200000
#define ARRIVAL_RATE    5.0       // lamda = 5, inter arrival time = 1/5
#define SERVICE_RATE    6.0       // Mu = 6  service time = 1 /6


int Nqueue = 0;
sg_mutex_t mutex;

struct request {
	int 	n_req;
	double 	t_arrival;   /* momento en el que llega */
	double 	t_service;   /* tiempo de servicio asignado */
};
	

/*-------------  UNIFORM [0, 1) RANDOM NUMBER GENERATOR  -------------*/
double uniform(void)
  {
        return drand48();
  }


/*-------------  UNIFORM (0, 1) RANDOM NUMBER GENERATOR  -------------*/
double uniform_pos(void)
{
        double g;

        g = uniform();
        while (g == 0.0)
                g = uniform();

        return g;
}


/*--------------  EXPONENTIAL RANDOM VARIATE GENERATOR  --------------*/
/* The exponential distribution has the form

   p(x) dx = exp(-x/landa) dx/landa

   for x = 0 ... +infty
*/
double exponential(double landa)
{
        /* 'exponential' returns a psuedo-random variate from a negative     */
        /* exponential distribution with mean 1/landa.                        */

        double u = uniform_pos();
        double mean = 1.0 / landa;


        return -mean * log(u);
}


/** Client  function  */
int client(int argc, char *argv[])
{
	int number_of_tasks = N_TASKS;
  	struct request *req;
  	double t_arrival;


	for (int i = 0; i < number_of_tasks; i++) {

      		/* espera la llegada de una peticion */
		/* ARRIVAL_RATE peticiones por segundo, lamda = ARRIVAL_RATE */

      		t_arrival = exponential((double) ARRIVAL_RATE);
		sg_actor_sleep_for(t_arrival);


      		/* crea la peticion */
      		req = (struct request *) malloc(sizeof(struct request));
      		req->t_arrival = simgrid_get_clock();                  // tiempo de llegada
      		req->t_service = exponential((double) SERVICE_RATE);   	// tiempo de servicio asignada a la tarea
							          // t medio de servicio = 1/SERVICE_RATE de seg
		req->n_req = i;

      		/* envia la tarea a la cola */
      		sg_mutex_lock(mutex);
      		Nqueue++;
      		sg_mutex_unlock(mutex);

		sg_mailbox_t mailbox = sg_mailbox_by_name("ServerHost");
                sg_mailbox_put_async(mailbox, req, 0);
	}


    	/* finalizar */
	req = (struct request *) malloc(sizeof(struct request));
	req->n_req = -1;
	sg_mailbox_t mailbox = sg_mailbox_by_name("ServerHost");
        sg_mailbox_put(mailbox, req, 0);

  	return 0;
}       /* end_of_client */


/** server function  */
int server(int argc, char *argv[])
{
  	int res;
  	int NqueueAvg = 0;
  	int Ntasks = 0;
  	double timeServiceAvg = 0.0;
  	double c;
  	struct request *req;


        sg_mailbox_t mailbox = sg_mailbox_by_name("ServerHost");

  	while (1) {
		req = (struct ClientRequest *) sg_mailbox_get(mailbox);

    		if (req->n_req == -1){
			free(req);
      			break;
    		}

    		Ntasks++;

		// elimina un elemento de la cola
    		sg_mutex_lock(mutex);
    		Nqueue--;
    		NqueueAvg = NqueueAvg + Nqueue;
    		sg_mutex_unlock(mutex);

		// ejecuta la tara, tiempo de servicio de la cola


		sg_actor_sleep_for(req->t_service);

     		c = simgrid_get_clock();

     		timeServiceAvg = timeServiceAvg + (c - (req->t_arrival));


    		free(req);
			
	}  

  	printf("--------------------------------------- \n");
  	printf("Tareas ejecutadas  = %d\n",    Ntasks);
  	printf("Tamanio medio de la cola = %g\n",   (double) NqueueAvg / Ntasks);
  	printf("Tiempo medio de servicio %g\n", (double) timeServiceAvg / Ntasks);
  	printf("--------------------------------------- \n");

  	printf("I'm done. See you!");
  
  	return 0;
}                               /* end_of_server */


/** Main function */
int main(int argc, char *argv[])
{

  	srand48((int) time(NULL));

  	if (argc < 3) {
    		printf("Usage: %s platform_file deployment_file\n", argv[0]);
    		exit(1);
  	}

	simgrid_init(&argc, argv);

  	mutex = sg_mutex_init();

  	simgrid_load_platform(argv[1]);

  	simgrid_register_function("client", client);
  	simgrid_register_function("server", server);

	simgrid_load_deployment(argv[2]);

  	simgrid_run();

  	printf("Simulation time %g\n", simgrid_get_clock());

    	return 0;
}                               /* end_of_main */
